package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.RelayUtils;

import androidx.appcompat.app.AppCompatActivity;

/**
 * relay control
 */
public class RelayActivity extends BaseActivity implements View.OnClickListener {
    private Button btnOpen;
    private Button btnClose;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_deer);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);

        btnOpen = findViewById(R.id.btn_open);
        btnClose = findViewById(R.id.btn_close);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        findViewById(R.id.tv1).setVisibility(View.VISIBLE);
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("relay control");
    }

    @Override
    protected void setListener() {
        btnOpen.setOnClickListener(this);
        btnClose.setOnClickListener(this);
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_open:
                RelayUtils.open();
                break;
            case R.id.btn_close:
                RelayUtils.close();
                break;
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
